-- diversiweb
DROP TABLE IF EXISTS `diversiweb`;
CREATE TABLE `diversiweb` (
  `id` bigint(20) NOT NULL,
  `perkara_id` bigint(20) DEFAULT NULL,
  `diversi_register_id` bigint(20) DEFAULT NULL,
  `pihak_diversi` varchar(1500) DEFAULT NULL,
  `no_reg_penyidik` varchar(50) DEFAULT NULL,
  `no_reg_penuntut_umum` varchar(50) DEFAULT NULL,
  `tgl_penetapan_musyawarah` date DEFAULT NULL,
  `tgl_musyawarah` date DEFAULT NULL,
  `kesepakatan_melaksanakan_diversi` int(1) DEFAULT NULL,
  `tgl_kesepakatan_diversi` date DEFAULT NULL,
  `tgl_laporan_hakim` date DEFAULT NULL,
  `tgl_penetapan_kesepakatan_diversi` date DEFAULT NULL,
  `no_penetapan_kesepakatan` varchar(200) DEFAULT NULL,
  `tgl_lap_pembimbing_masyarakat` date DEFAULT NULL,
  `hasil_lap_pembimbing_masyarakat` int(1) DEFAULT NULL,
  `nomor_laporan_pembimbing_masyarakat` varchar(50) DEFAULT NULL,
  `hasil_diversi` varchar(50) DEFAULT NULL,
  `dibuka_kembali` int(1) DEFAULT NULL,
  `no_dibuka_kembali` varchar(50) DEFAULT NULL,
  `tgl_dibuka_kembali` date DEFAULT NULL,
  `tgl_pelaksanaan_isi_diversi` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- menu
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu` (
  `id` smallint(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent` smallint(11) DEFAULT NULL,
  `urutan` smallint(11) DEFAULT NULL,
  `title` varchar(150) DEFAULT NULL,
  `link` varchar(225) DEFAULT NULL,
  `params` varchar(255) DEFAULT NULL,
  `publish` char(1) NOT NULL DEFAULT 'Y',
  `jenis_pengadilan` char(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=latin1;

insert  into `menu`(`id`,`parent`,`urutan`,`title`,`link`,`params`,`publish`,`jenis_pengadilan`) values 
(1,NULL,1,'Beranda','list_perkara',NULL,'Y',NULL),
(2,NULL,2,'Perdata Umum',NULL,NULL,'Y','1'),
(3,NULL,3,'Perdata Khusus',NULL,NULL,'Y','1'),
(4,NULL,4,'Pidana',NULL,NULL,'Y','1'),
(5,NULL,5,'Pidana Khusus',NULL,NULL,'Y','1'),
(6,NULL,6,'Jadwal Sidang','list_jadwal_sidang',NULL,'Y',NULL),
(7,2,1,'Perdata Gugatan','list_perkara','var_id=1;var_tahapan=10;','Y','1'),
(8,2,4,'Perdata Permohonan','list_perkara','var_id=2;var_tahapan=10;','Y','1'),
(12,4,1,'Pidana Biasa','list_perkara','var_id=111;var_tahapan=10;','Y','1'),
(13,4,2,'Pidana Singkat','list_perkara','var_id=112;var_tahapan=10;','Y','1'),
(14,4,3,'Pidana Cepat','list_perkara','var_id=113;var_tahapan=10;','Y','1'),
(15,4,4,'Praperadilan','list_perkara','var_id=119;var_tahapan=10;','T','1'),
(16,4,5,'Perkara Lalu Lintas','list_perkara','var_id=114;var_tahapan=10;','Y','1'),
(17,2,2,'Perdata Gugatan Sederhana','list_perkara','var_id=8;var_tahapan=10;','Y','1'),
(18,2,3,'Perdata Gugatan Bantahan','list_perkara','var_id=7;var_tahapan=10;','Y','1'),
(19,5,1,'Pidana Anak','list_perkara','var_id=118;var_tahapan=10;','Y','1'),
(20,3,1,'Hak Kekayaan Intelektual (HKI)','list_perkara','var_id=5;var_tahapan=10;','Y','1'),
(21,3,2,'Kepailitan & PKPU','list_perkara','var_id=3,4;var_tahapan=10;','Y','1'),
(22,3,3,'Pengadilan Hubungan Industrial (PHI)','list_perkara','var_id=6;var_tahapan=10;','Y','1'),
(23,5,2,'Tindak Pidana Korupsi','list_perkara','var_id=115;var_tahapan=10;','Y','1'),
(24,5,3,'Pidana Perikanan','list_perkara','var_id=116;var_tahapan=10;','Y','1'),
(25,5,4,'Hak Asasi Manusia','list_perkara','var_id=117;var_tahapan=10;','Y','1'),
(26,4,4,'Pidana Pra Peradilan','list_perkara','var_id=119;var_tahapan=10;','Y','1'),
(27,NULL,7,'Laporan',NULL,NULL,'Y',NULL),
(28,27,8,'Statistik Perkara','statistik_perkara','','Y',NULL),
(29,NULL,8,'Delegasi',NULL,NULL,'Y','1'),
(30,29,1,'Delegasi Masuk','list_delegasi','var_id=1;','Y','1'),
(31,29,1,'Delegasi Keluar','list_delegasi','var_id=2;','Y','1'),
(32,40,1,'Perdata Gugatan','list_perkara','var_id=9;var_tahapan=10;','Y','3'),
(33,NULL,2,'Perdata Gugatan','list_perkara','var_id=15;var_tahapan=10;','Y','4'),
(34,NULL,3,'Perdata Permohonan','list_perkara','var_id=16;var_tahapan=10;','Y','4'),
(35,NULL,4,'Jinayat',NULL,NULL,'Y','4'),
(36,35,1,'Register Perkara Jinayat','list_perkara','var_id=122;var_tahapan=10;','Y','4'),
(37,35,1,'Praperadilan Jinayat','list_perkara','var_id=123;var_tahapan=10;','Y','4'),
(38,NULL,4,'Pidana Kejahatan','list_perkara','var_id=120;var_tahapan=10;','Y','2'),
(39,NULL,5,'Pidana Pelanggaran','list_perkara','var_id=121;var_tahapan=10;','Y','2'),
(40,NULL,2,'Perkara',NULL,NULL,'Y','3'),
(41,40,2,'Permohonan UU AP','list_perkara','var_id=10;var_tahapan=10;','Y','3'),
(42,40,3,'Gugatan Keberatan (KIP)','list_perkara','var_id=11;var_tahapan=10;','Y','3'),
(43,3,4,'KPPU','list_perkara','var_id=19;var_tahapan=10','Y','1'),
(45,NULL,3,'Pidana Militer',NULL,NULL,'Y','2'),
(46,45,1,'Perbedaan Pendapat','list_perkara','var_id=124;var_tahapan=10;','Y','2'),
(47,NULL,5,'Jinayat Anak',NULL,NULL,'Y','4'),
(48,47,1,'Register Perkara Jinayat Anak','list_perkara','var_id=125;var_tahapan=10;','Y','4');

DROP TABLE IF EXISTS `perbaikangugatanweb`;
CREATE TABLE `perbaikangugatanweb`( `ID` BIGINT(20) NOT NULL AUTO_INCREMENT, 
  `IDPerkara` BIGINT(20) UNSIGNED NOT NULL, 
  `statusPerbaikan` CHAR(1), 
  `isPerbaikan` CHAR(1), 
  `isiSaranPerbaikan` LONGTEXT, 
  `tglSaranPerbaikan` DATE, 
  `tglDinyatakanLengkap` DATE, 
  `petitum` LONGTEXT, 
  PRIMARY KEY (`ID`, `IDPerkara`) ) ENGINE=INNODB CHARSET=latin1 COLLATE=latin1_swedish_ci; 

ALTER TABLE `dataumumweb` CHANGE `noPerkara` `noPerkara` VARCHAR(250) CHARSET latin1 COLLATE latin1_swedish_ci NULL; 

ALTER TABLE perkarabiayaweb
ADD COLUMN IDGeneral BIGINT(20) NULL DEFAULT 0 COMMENT 'general_id merujuk pada setiap tabel perkara' AFTER IDPerkara , 
CHANGE IDTahapan IDTahapan INT(11) UNSIGNED   NULL COMMENT 'Tahapan Proses : merujuk ke tabel tahapan_proses (by system)' AFTER IDGeneral , COMMENT='' ;

ALTER TABLE perkaraprosesweb 
	ADD COLUMN IDGeneral BIGINT(20) NOT NULL DEFAULT 0 AFTER IDPerkara , 
	ADD COLUMN urutan TINYINT(4) NOT NULL DEFAULT 0 AFTER proses,
	CHANGE IDTahapan IDTahapan INT(11)   NULL COMMENT 'Id Tahapan proses: merujuk ke tabel tahapan_proses kolom tahapan_id(by system' AFTER IDGeneral , 
	DROP KEY `PRIMARY`, ADD PRIMARY KEY(IDPerkara,IDGeneral,IDProses,urutan) ;

ALTER TABLE `eksekusiweb` ADD COLUMN `alasanEksekusiTidakDilaksanakan` VARCHAR(255) NULL AFTER `statusEksekusiText`; 
ALTER TABLE `eksekusiweb` ADD COLUMN `pelaksanaanTeguranEksekusiKedua` DATE NULL COMMENT 'Tanggal Pelaksanaan Teguran Eksekusi Kedua: isian tanggal' AFTER `pelaksanaanTeguranEksekusi`; 
ALTER TABLE `eksekusiweb` ADD COLUMN `pelaksanaanEksekusiNama` VARCHAR(50) NULL AFTER `alasanEksekusiTidakDilaksanakan`; 
ALTER TABLE `eksekusiweb` ADD COLUMN `ID` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT FIRST, DROP PRIMARY KEY, ADD PRIMARY KEY (`ID`); 

ALTER TABLE `eksekusidetilweb` ADD COLUMN `IDEksekusi` BIGINT(20) NOT NULL AFTER `ID`;

ALTER TABLE `prosesweb` DROP PRIMARY KEY; 

ALTER TABLE `kasasiweb` CHANGE `pemohonkasasi` `pemohonkasasi` LONGTEXT NULL COMMENT 'Pihak yang dimohonkan Kasasi: (by system)'; 
ALTER TABLE `alurperkaraweb` CHANGE `nama` `nama` VARCHAR(100) CHARSET latin1 COLLATE latin1_swedish_ci NULL; 
ALTER TABLE `mediasiweb` CHANGE `nama` `nama` VARCHAR(300) CHARSET latin1 COLLATE latin1_swedish_ci NULL; 

DROP TABLE IF EXISTS `sumberhukumweb`;
CREATE TABLE `sumberhukumweb` (
  `ID` int(11) NOT NULL,
  `nama` varchar(100) DEFAULT NULL,
  `IDJenispengadilan` char(1) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

insert  into `sumberhukumweb`(`ID`,`nama`,`IDJenispengadilan`) values 
(1,'KUH Perdata (BW)','1'),
(2,'KUH Dagang','1'),
(3,'Adat','1'),
(4,'UU/PP','1'),
(6,'Peraturan Perundangan-Undangan','3'),
(7,'Asas-Asas Pemerintahan Yang Baik','3'),
(8,'Kompilasi Hukum Islam','4'),
(9,'Kompilasi Hukum Ekonomi Syariah','4'),
(10,'Fiqh Islam','4'),
(11,'UU/PP','4'),
(12,'Perpu dan Asas-Asas Pemerintahan Yang Baik','3'),
(13,'Qanun Aceh','4'),
(14,'Yurisprudensi','1'),
(15,'RV','1'),
(16,'Yurisprudensi','4'),
(17,'HIR/RBg','1');